function [ l ] = findinterval( n,Delta,t )
%Get PROPER ext knot sequence interval that t belongs for S^r_d(\Delta)
%   delta is the extended knot sequence.
%   It returns the left index of first PROPER interval to which point
%   belongs, e.g. if in [y_3,y_4] (and say also [y_4,y_5]) it will return
%   l=3.

%Delta = extpar(Delta,r,d);% Build extended knot sequence
found = 0;
l=1;
while l < size(Delta,2) && found == 0 %If still a forward interval and not found
    if Delta(1,l) <= t && t < Delta(1,l+1) %Check if found
        found = 1;
    else
        l = l + 1; %Else cycle to the next
    end
end

if found == 0
    l = n; %The extended knot sequence has more points
           %than the dim of S^r_d(delta).  If cycled that
           %far we write this in.
end

end

